# SOLUTIONS TO SPAM PROCESSING PROBLEM

This directory contains solutions to the DeapSECURE hands-on activities.



## One-Month Spam Computation

The solutions listed below are in increasing level of features.


### `month03.slurm`

The very first HPC job with only one option (--job-name)
to specify the job name


### `month03-timed.slurm`

Added timing routine:

* `d1` captures the start time (expressed as seconds since a reference time)
* `d2` captures the end time (also expressed as seconds since a reference time)

Run time is calculated as the difference between `d2` and `d1`.
The script will print the run time at the end like this:

```
Total time to run is :  30 seconds
```

### `month03-outfile.slurm`

Further improvement: save the analysis output to a separate file
so that it can be processed with a script without having to worry
about the extra printout of "Total time to run".


### `month03-outfile2.slurm`

Even further improvement: save the uncaptured output to
a file (name specified by `#SBATCH --output` directive).




<!-- ------------------------------------------------------------ -->

## Entire-Year Spam Computation

The solutions listed below are in increasing level of features.


### `year1998.slurm`

Based on a single `for` loop.
Developed from a template
(see `/handson/Spam_bash/templates/year1998.template`).
Timing is added (see `month03-timed.slurm`) for the entire processing.


### `year1998-timed.slurm`

Based on `year1998.slurm`, added per-month timing measurement & printing.


### `year1998-months.slurm`

Based on `year199-timed8.slurm`, added an option to specify the command-line
argument for the months to process.


