#!/bin/bash
#
# Updates symlinks to spam datasets (by year)
# By default we only link 1998 and 1999.
# If you want all of them, then you must invoke this script
# with the "--all" flag.
#

if [ -z "$DEAPSECURE_ROOT_DIR" ]; then
    DEAPSECURE_ROOT_DIR=/scratch/Workshops/DeapSECURE
fi


if [ "$1" = "--all" ]; then
    DATASETS=$(seq 1998 2018)
else
    DATASETS="1998 1999"
fi

for Y in $DATASETS; do
    if [ ! -e $Y ]; then
        ln -s $DEAPSECURE_ROOT_DIR/datasets/untroubled-spam/$Y .
    fi
done
